<?php

namespace Stripe\Issuing;

/**
 * Class Dispute
 *
 * @property string $id
 * @property string $object
 * @property int $amount
 * @property int $created
 * @property string $currency
 * @property string|\Stripe\Issuing\Transaction $disputed_transaction
 * @property \Stripe\StripeObject $evidence
 * @property bool $livemode
 * @property \Stripe\StripeObject $metadata
 * @property string $reason
 * @property string $status
 *
 * @package Stripe\Issuing
 */
class Dispute extends \Stripe\ApiResource
{
    const OBJECT_NAME = 'issuing.dispute';

    use \Stripe\ApiOperations\All;
    use \Stripe\ApiOperations\Create;
    use \Stripe\ApiOperations\Retrieve;
    use \Stripe\ApiOperations\Update;
}
